/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.service;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSystemAdministration;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.resources.VWResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class VWConfigStatisticsPane
extends JPanel {
    protected JTextField m_consolidationIntervalTextField = null;
    protected VWSystemAdministration m_sysAdmin = null;
    protected int m_originalConsolidationInterval;
    private Dialog m_parentDialog = null;

    public VWConfigStatisticsPane(Dialog parentDialog, VWSystemAdministration sysAdmin) {
        this.m_parentDialog = parentDialog;
        this.m_sysAdmin = sysAdmin;
        try {
            this.setLayout(new BorderLayout(6, 6));
            this.add((Component)this.createStatisticsPanel(), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseResources() {
        if (this.m_consolidationIntervalTextField != null) {
            this.m_consolidationIntervalTextField.removeAll();
            this.m_consolidationIntervalTextField = null;
        }
        this.m_sysAdmin = null;
        this.m_parentDialog = null;
        this.removeAll();
    }

    protected JPanel createStatisticsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(10, 10));
        panel.add((Component)this.createStatisticsPanelTop(), "Center");
        Color bgColor = panel.getBackground();
        JTextArea noteTextArea = new JTextArea();
        noteTextArea.setComponentOrientation(this.m_parentDialog.getComponentOrientation());
        noteTextArea.setBackground(bgColor);
        noteTextArea.setEditable(false);
        noteTextArea.setLineWrap(true);
        noteTextArea.setWrapStyleWord(true);
        noteTextArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        noteTextArea.append(VWResource.NoteStatisticsMsg);
        noteTextArea.append("\n\n");
        noteTextArea.append(VWResource.NoteSystemWideConfigStatistics);
        panel.add((Component)noteTextArea, "Last");
        return panel;
    }

    protected JPanel createStatisticsPanelTop() {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            this.m_originalConsolidationInterval = this.m_sysAdmin.getStatisticsConsolidationInterval();
            this.m_consolidationIntervalTextField = new JTextField(Integer.toString(this.m_originalConsolidationInterval));
            mainPanel = new JPanel();
            mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            mainPanel.setLayout(new GridBagLayout());
            gbConst.fill = 0;
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(10, 10, 4, 4);
            gbConst.anchor = 23;
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            mainPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.ConsolidationIntervalLabel)), gbConst);
            gbConst.fill = 2;
            gbConst.weightx = 1.0;
            gbConst.gridx = 1;
            mainPanel.add((Component)this.m_consolidationIntervalTextField, gbConst);
            gbConst.fill = 1;
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.weightx = 1.0;
            gbConst.weighty = 1.0;
            gbConst.gridwidth = 0;
            mainPanel.add(Box.createVerticalStrut(100), gbConst);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    public boolean update() {
        boolean bSuccess = false;
        int iConsolidationInterval = 0;
        try {
            iConsolidationInterval = this.fetchConsolidationInterval();
            if (iConsolidationInterval > 0) {
                bSuccess = true;
                if (this.m_sysAdmin.getStatisticsConsolidationInterval() != iConsolidationInterval) {
                    this.m_sysAdmin.setStatisticsConsolidationInterval(iConsolidationInterval);
                }
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            bSuccess = false;
            JOptionPane.showMessageDialog(this.m_parentDialog, ex.getLocalizedMessage(), VWResource.s_error, 0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            bSuccess = false;
        }
        return bSuccess;
    }

    private int fetchConsolidationInterval() {
        int iConsolidationInterval = 0;
        String sConsolidationInterval = this.m_consolidationIntervalTextField.getText();
        if (sConsolidationInterval != null) {
            try {
                iConsolidationInterval = Integer.valueOf(sConsolidationInterval);
                if (iConsolidationInterval > 1440 || iConsolidationInterval < 1) {
                    JOptionPane.showMessageDialog(this, VWResource.InvalidConsolidationInterval.toString(sConsolidationInterval), VWResource.ErrorMessage, 0);
                    iConsolidationInterval = 0;
                    this.m_consolidationIntervalTextField.setText(String.valueOf(this.m_originalConsolidationInterval));
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, VWResource.InvalidConsolidationInterval.toString(sConsolidationInterval), VWResource.ErrorMessage, 0);
                this.m_consolidationIntervalTextField.setText(String.valueOf(this.m_originalConsolidationInterval));
            }
        } else {
            JOptionPane.showMessageDialog(this, VWResource.InvalidConsolidationInterval.toString("null"), VWResource.ErrorMessage, 0);
            this.m_consolidationIntervalTextField.setText(String.valueOf(this.m_originalConsolidationInterval));
        }
        return iConsolidationInterval;
    }
}

